
// This can be useful for forcing data structures mirrored between
//  UnrealScript and C++ to be identical, even on new systems. The gist is
//  that we force everything to pack down as tightly as possible, with no
//  padding for alignment, etc, and set up the Engine to treat the data
//  structures as such on the UnrealScript side of things, too.
// This aids in removing unusual crashes when you are first getting the code
//  up and running on a new platform, since you hopefully won't get bitten by
//  unexpected alignment and padding issues.
// This should NOT be used in production code, since unaligned memory access
//  is almost universally a performance hit. Just use this as a first step
//  on new OS/CPU/compiler/platform ports.
// This file gets included before classes that need to be mirrored between
//  Uscript and C++. Generally, it's included at the top of a header (after
//  any other includes), and its counterpart is included at the bottom.
// *Classes.h (headers generated by "ucc make") automatically include these
//  files. You'd only ever need to worry about this if you are writing your
//  own mirrored class/struct that isn't autogenerated by ucc make. Most
//  things that aren't mirrored shouldn't use this, and thus won't be tightly
//  packed.
//
//    ...good luck.
//
//  --ryan.


#if FORCE_EXTREME_PACKING
  // you can only include this once at a time. FIXME: make these stack?
  #ifdef EXTREME_PACKING_ENFORCED
    #error Extreme packing mojo multiply-defined.
  #endif

  #define EXTREME_PACKING_ENFORCED 1
  #ifdef _MSC_VER
    #pragma warning(disable : 4103)
  #endif

  #if SUPPORTS_PRAGMA_PACK
    #pragma pack(push, 1)
  #else
    #pragma pack(1)
  #endif

  #ifdef GCC_PACK
    #define GCC_PACK_TMP(x) GCC_PACK(x)
    #undef GCC_PACK
    #define GCC_PACK(x)
  #endif
#endif

// end of UnForcePacking_begin.h ...

